/*
 * QrfeReader.h
 *
 *  Created on: 25.11.2009
 *      Author: stefan.detter
 */

#ifndef QRFEPROTOCOLHANDLERGLOBAL_H_
#define QRFEPROTOCOLHANDLERGLOBAL_H_

#include <QObject>
#include <QrfeGlobal>

#include <QMetaType>

namespace QrfeGlobal
{
	Q_ENUMS(DeviceType ReaderState ReaderSystem Result)

	typedef enum {
		DEVICE_Serial,
		DEVICE_TCP,
		DEVICE_NAMEDPIPE,
		DEVICE_BONJOUR,
		DEVICE_PIPE,
		DEVICE_HID
	} DeviceType;

	typedef enum {
		STATE_IDLE,
		STATE_SCANNING,
		STATE_REBOOTING
	} ReaderState;

	typedef enum
	{
		BOOTLOADER,
		FIRMWARE
	} ReaderSystem;

	typedef enum {
		RES_OK,
		RES_ERROR,
		RES_COMMERROR,
		RES_NORESPONSE,
		RES_NA
	} Result;

	typedef struct{
		QByteArray 	tagId;

		bool 		hasAntenna;
		uchar 		antennaId;

		bool 		hasRSSI;
		QByteArray 	rssi;

		bool 		hasReadFrequency;
		ulong		readFrequency;

		bool 		hasMemory;
		uchar 		memBank;
		ushort 		memAddr;
		QByteArray  memData;

		bool 		hasTrigger;
		uchar 		trigger;

		bool 		hasHandle;
		QByteArray 	handle;

		bool 		hasState;
		ushort 		state;

		bool 		hasBattery;
		uchar 		battery;

		bool 		hasPC;
		QByteArray 	pc;

        bool 		hasRN16;
        QByteArray 	rn16;

		bool 		hasMessageID;
		uchar 		messageID;

        bool 		hasNxpBrandId;
        QByteArray 	nxpBrandId;

		bool 		hasApplicationInfo;
		QByteArray 	applicationInfo;
	} TagEvent;

	QString tagEventToString(const TagEvent& event);
};

Q_DECLARE_METATYPE(QrfeGlobal::TagEvent)

class __init_QrfeProtocolHandlerGlobal
{
public:
	__init_QrfeProtocolHandlerGlobal();
};

#endif /* QRFEPROTOCOLHANDLERGLOBAL_H_ */
